#version 330 core
layout(location = 0) in vec2 aPos;
layout(location = 1) in vec2 aTexCoord;

out vec2 uv;
out vec2 resolution;

// Uniforms for object transformation
uniform float iTime;           // Time for animations
uniform vec2 iResolution;      // Screen resolution
 
void main() 
{    
    // Pass UV coordinates to fragment shader
    uv = aTexCoord;
    
    // Pass resolution to fragment shader
    resolution = iResolution;
    
    // Set final position (for 2D, we keep z=0 and w=1)
    gl_Position = vec4(aPos, 0.0, 1.0);
} 
